﻿using System;
using System.Collections.Generic;
using System.Resources;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Specialized;
using System.Reflection;
using System.Text;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.Business.Utilities;
using System.Web.Configuration;

/// <summary>
/// Summary description for BasePage
/// </summary>
public abstract class BasePage : Page
{
    
    #region Constructor

    protected static ResourceManager resources;

    private UserAccountManager _currentUser;
    private bool _errorOnSavedReceived;
    private Dictionary<string, string> _OnStartupAlertErrorCollection;

    /// <summary>
    /// Set the EntityInstitution if page should check permissions based on institution.
    /// </summary>
    protected int? EntityInstitution;

    public BasePage(bool errorOnSavedReceived) 
    {
        resources = new ResourceManager("Portal.strings", Assembly.GetExecutingAssembly());
        this.Load += new EventHandler(BasePage_Load);

        _errorOnSavedReceived = errorOnSavedReceived;
        SuppressSaveMessage = true;
    }
    public BasePage()
    {
        resources = new ResourceManager("Portal.strings", Assembly.GetExecutingAssembly());
        this.Load += new EventHandler(BasePage_Load);
        SuppressSaveMessage = true;
    }
    public Menu MenuHorizontalMenu;
    public Menu MenuLeftNavigation;
    public Label LabelBreadCrumb;

    #endregion Constructor

    #region Properities

    /// <summary>
    /// Get whether or not the page requires authentication to access.  Assume true but allow specific pages to override.
    /// </summary>
    protected virtual bool RequiresAuthentication
    {
        get { return true; }
    }
    private void BasePage_Load(object sender, EventArgs e)
    {
        // Kick the user out if the page requires authentication but the user somehow isn't (like if the auth system has been
        // maliciously bypassed).
        if (RequiresAuthentication && (!User.Identity.IsAuthenticated))
        {
            Response.Redirect("ErrorPage.aspx?id=404");
        }

        Response.Cache.SetExpires(DateTime.Now);

    }
    //private SessionFacade _SessionFacade = new SessionFacade();

    public UserAccountManager CurrentUser
    {
        get
        {
            return _currentUser;
        }
    }

    public bool IgnoreCapabilityCheck { get; set; }

    public bool ReadOnly { get; set; }
    public bool AllowInsert { get; set; }
    public bool AllowDelete { get; set; }
    public bool AllowUpdate { get; set; }
    public bool BusinessObjectSaveEventReceived { get; set; }
    public bool IsSaveSuccess { get; set; }
    public bool SuppressSaveMessage { get; set; }


    #endregion Properties

    #region Abstract Methods

    /// <summary>
    /// TopMenuName is the menu item in the top horizontal menu where this page falls under
    /// </summary>
    public abstract string TopMenuName();

    /// <summary>
    /// MenuItemName is the value of the left menu link for this page
    /// </summary>
    public abstract string MenuItemName();

    /// <summary>
    /// The list of capabilities that a user needs to access this page.  A single page may have more than one
    /// capability associated with it.
    /// </summary>
    public abstract string AppObjectCode();
    
    #endregion Abstract Methods

    #region Public Methods

    /// <summary>
    /// Select returns the base application path.
    /// </summary>
    /// <param name="context">Context object</param>
    /// <returns>Returns the base application path.</returns>
    public static string RootPath(HttpContext context)
    {
        string urlSuffix = context.Request.Url.Authority + context.Request.ApplicationPath;
        return context.Request.Url.Scheme + @"://" + urlSuffix + "/";
    }

    public static NameValueCollection DecryptQueryString(string queryString)
    {
        //return StringHelpers.DecryptQueryString(queryString);
        NameValueCollection myColl = new NameValueCollection();
        myColl.Add("a", "1");
        return myColl;
    }

    public static string EncryptQueryString(NameValueCollection queryString)
    {        
        //return StringHelpers.EncryptQueryString(queryString);
        string myString = "";
        return myString;
    }

    /// <summary>
    /// You must pass in a string that uses the QueryStringHelper.DELIMITER as the delimiter.
    /// This will also append the "?" to the beginning of the query string.
    /// </summary>
    /// <param name="queryString"></param>
    /// <returns></returns>
    public static string EncryptQueryString(string queryString)
    {
        //return StringHelpers.EncryptQueryString(queryString);
        string qs = "";
        return qs;
    }

    //Chapter 9: Printing
    public string GetPrintButtonScript(Button btn)
    {        
        StringBuilder printButtonScript = new StringBuilder();

        //Get the postback script.
        string postback = this.Page.ClientScript.GetPostBackEventReference(btn, "");

        //Change target to a new window.  Name the window the current date and time so multiple windows can
        //be opened.
        printButtonScript.Append("var today = new Date();");
        printButtonScript.Append("var newWindowName = today.getFullYear().toString() + today.getMonth().toString() + today.getDate().toString() + today.getHours().toString() + today.getHours().toString() + today.getMinutes().toString() + today.getSeconds().toString() + today.getMilliseconds().toString();");

        printButtonScript.Append("document.forms[0].target = newWindowName;");

        //TODO: Added root path after this was turned in.
        //Show the please wait screen.
        printButtonScript.Append("window.open('" + RootPath(base.Context) + "/Reports/PleaseWait.html', newWindowName, 'scrollbars=yes,status=no,resizable=yes');");

        //Add the postback script.
        printButtonScript.Append(postback + ";");

        //Reset target back to itself so other controls will post back to this form.
        printButtonScript.Append("document.forms[0].target='_self';");
        //Return false to stop page submitting.
        printButtonScript.Append("return false;" + Environment.NewLine);

        return printButtonScript.ToString();
    }

    #endregion Public Methods

    #region Export Grid to Excel Methods

    
    public void ExportGridViewToExcel(GridView GridView1, string filename)
    {
        PrepareGridViewForExport(GridView1);

        HtmlForm form = new HtmlForm();

        string attachment = "attachment; filename=" + filename;

        Response.ClearContent();
        Response.AddHeader("content-disposition", attachment);
        Response.ContentType = "application/vnd.ms-excel";
        System.IO.StringWriter sw = new System.IO.StringWriter();
        HtmlTextWriter htw = new HtmlTextWriter(sw);

        form.Controls.Add(GridView1);

        this.Controls.Add(form);

        form.RenderControl(htw);

        //GridView1.RenderControl(htw);
        Response.Write(sw.ToString());
        Response.End();

    }

    public void PrepareGridViewForExport(Control gv)
    {

        Hashtable htControls = new Hashtable();

        htControls.Add("LinkButton", "Text");
        htControls.Add("HyperLink", "Text");
        htControls.Add("DropDownList", "SelectedItem");
        htControls.Add("CheckBox", "Checked");

        Literal l = new Literal();

        for (int i = 0; i < gv.Controls.Count; i++)
        {

            if ((null != htControls[gv.Controls[i].GetType().Name]) || (null != htControls[gv.Controls[i].GetType

               ().BaseType.Name]))
            {

                l.Text = GetControlPropertyValue(gv.Controls[i], htControls);

                gv.Controls.Remove(gv.Controls[i]);

                gv.Controls.AddAt(i, l);

            }

            if (gv.Controls[i].HasControls())
            {

                PrepareGridViewForExport(gv.Controls[i]);

            }

        }

    }

    private string GetControlPropertyValue(Control control, Hashtable htControls)
    {

        Type controlType = control.GetType();

        string strControlType = controlType.Name;

        string strReturn = "Error";

        bool bReturn;



        PropertyInfo[] ctrlProps = controlType.GetProperties();

        string ExcelPropertyName = (string)htControls[strControlType];

        if (ExcelPropertyName == null)
        {

            ExcelPropertyName = (string)htControls[control.GetType().BaseType.Name];

            if (ExcelPropertyName == null)

                return strReturn;

        }

        foreach (PropertyInfo ctrlProp in ctrlProps)
        {

            if (ctrlProp.Name == ExcelPropertyName &&

            ctrlProp.PropertyType == typeof(String))
            {

                try
                {

                    strReturn = (string)ctrlProp.GetValue(control, null);

                    break;

                }

                catch
                {

                    strReturn = "";

                }

            }

            if (ctrlProp.Name == ExcelPropertyName &&

            ctrlProp.PropertyType == typeof(bool))
            {

                try
                {

                    bReturn = (bool)ctrlProp.GetValue(control, null);

                    strReturn = bReturn ? "True" : "False";

                    break;

                }

                catch
                {

                    strReturn = "Error";

                }

            }

            if (ctrlProp.Name == ExcelPropertyName &&

            ctrlProp.PropertyType == typeof(ListItem))
            {

                try
                {

                    strReturn = ((ListItem)(ctrlProp.GetValue(control, null))).Text;

                    break;

                }

                catch
                {

                    strReturn = "";

                }

            }

        }

        return strReturn;

    }

    #endregion 

    #region Overrides

    protected override void OnPreInit(EventArgs e)
    {
        //get theme from user profile
        
        //to do : get theme from web.config
        this.Theme = "TBI";        

    }

    protected override void OnInit(EventArgs e)
    {
        if (DisplayApplicationWarning() == false)
        {
            Session["SkipWarning"] = "Yes";

            base.OnInit(e);

            CheckCapabilities();

            if (!isQueryStringValid())
            {
                //redirect to error handling page
                Response.Redirect("ErrorPage.aspx?id=qs");
            }

            LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");

            if (!IsPostBack)
            {
                BuildMenusAndBreadCrumb();
            }
        }
    }

    protected void BuildMenusAndBreadCrumb()
    {
        //Get menu list based on user access
        //Performance Enhancement

        _currentUser = (UserAccountManager)HttpContext.Current.User;
        List<string> pages = new List<string>();

        if (Session["UserAccessiblePages"] == null)
        {
            pages = new List<string>();

            SqlDataReader sReader = SqlProvider.ExecuteSPReader("RegistryConnectionString", "CRS_SP_GET_PAGES_ACCESSIBLE_BY_USER", new object[] { _currentUser.RegistryId, _currentUser.UserId });

            while (sReader.Read())
            {
                pages.Add((string)(sReader["CODE"]));
            }

            Session["UserAccessiblePages"] = pages;
        }
        else
        {
            pages = (List<string>)Session["UserAccessiblePages"];
        }

        string[] pagesAccessibleByUser = new string[pages.Count];

        for (int i = 0; i < pages.Count; i++)
        {
            pagesAccessibleByUser[i] = pages[i];
        }

        //string[] pagesAccessibleByUser = ((UserAccountManager)HttpContext.Current.User).GetPagesByCode();

        MenuHorizontalMenu = (Menu)Master.FindControl("MenuHorizontalMenu");
        MenuLeftNavigation = (Menu)Master.FindControl("MenuLeftNavigation");
        //LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");

        //Populate left menu and breadcrumb - based on user roles
        MenuBuilder.BuildDynamicNavigationItems(HttpContext.Current.Request.Url.PathAndQuery, MenuHorizontalMenu, TopMenuName(), MenuLeftNavigation, MenuItemName(), LabelBreadCrumb, pagesAccessibleByUser);

    }

    protected override void OnPreRender(EventArgs e)
    {        
        //if the page has EntityInstituion then check the permissions based on institution 
        if (EntityInstitution.HasValue && EntityInstitution != 0)
        {
            CheckCapabilities(EntityInstitution.GetValueOrDefault());
        }

        //RenderStartUpMessage(BusinessObjectSaveEventReceived);
        //RenderStartUpMessage based on save status
        if(!SuppressSaveMessage)
        {
            RenderStartUpMessage(IsSaveSuccess);
        }

        base.OnPreRender(e);
    }

    #endregion Overrides

    #region Virtual Methods

    public virtual void CheckCapabilities()
    {
        if (IgnoreCapabilityCheck == false)
        {            
            //Get user permissions
            _currentUser = (UserAccountManager)HttpContext.Current.User;
            if (_currentUser.HasAccessToRegistry() == false)
                NoAccessToPage();
            else
            {
                Permissions Perm = _currentUser.GetPermissions(AppObjectCode());
                if (Perm.NoAccess == true)
                    NoAccessToPage();
                else if (Perm.ReadOnly == true)
                    MakeFormReadOnly(AppObjectCode(), this.Controls);

                AllowDelete = Perm.DeleteAllowed;
                AllowInsert = Perm.InsertAllowed;
                ReadOnly = Perm.ReadOnly;
                AllowUpdate = Perm.UpdateAllowed;

            }
        }
    }

    public virtual void CheckCapabilities(int InstitutionId)
    {
        if (IgnoreCapabilityCheck == false)
        {
            //Get user permissions
            _currentUser = (UserAccountManager)HttpContext.Current.User;
            if (_currentUser.HasAccessToRegistry() == false)
                NoAccessToPage();
            else
            {
                Permissions Perm = _currentUser.GetPermissions(AppObjectCode(),InstitutionId);
                if (Perm.NoAccess == true)
                    NoAccessToPage();
                else if (Perm.ReadOnly == true)
                    MakeFormReadOnly(AppObjectCode(), this.Controls);

                AllowDelete = Perm.DeleteAllowed;
                AllowInsert = Perm.InsertAllowed;
                ReadOnly = Perm.ReadOnly;
                AllowUpdate = Perm.UpdateAllowed;

            }
        }
    }
        
    protected virtual void NoAccessToPage()
    {     
        //You do not access to the system.
        //If a page has more than one capability you should override this method because a user could
        //have access to one section but not another so you do not want them to get an error
        Response.Redirect("ErrorPage.aspx?id=100");
        //throw new AccessViolationException("You do not have access to this screen.");
    }

    public virtual void CustomReadOnlyLogic(string capabilityName)
    {
        //Override this method in a page that has custom logic for non standard controls on the screen.
    }

    /// <summary>
    /// The default implementation will make all controls disabled.
    /// If you have more than one capability associated with a page you should override this method
    /// with the special logic for each capability in the page.
    /// </summary>
    /// <param name="capabilityName"></param>
    /// <param name="controls"></param>
    public virtual void MakeFormReadOnly(string capabilityName, ControlCollection controls)
    {
        ReadOnly = true;

        SetControlsEnableState(controls, false);

        CustomReadOnlyLogic(capabilityName);
    }

    public virtual void EnableAllControls(ControlCollection controls)
    {
        SetControlsEnableState(controls, true);
    }

    #endregion Virtual Methods

    #region Private Methods
       
    private void SetControlsEnableState(ControlCollection controls, bool enabled)
    {

        foreach (Control c in controls)
        {
            if (c is TextBox)
            {
                ((TextBox)c).Enabled = enabled;
            }
            else if (c is RadioButton)
            {
                ((RadioButton)c).Enabled = enabled;
            }
            else if (c is DropDownList)
            {
                ((DropDownList)c).Enabled = enabled;
            }
            else if (c is CheckBox)
            {
                ((CheckBox)c).Enabled = enabled;
            }
            else if (c is RadioButtonList)
            {
                ((RadioButtonList)c).Enabled = enabled;
            }
            else if (c is CheckBoxList)
            {
                ((CheckBoxList)c).Enabled = enabled;
            }
            else if (c is RequiredFieldValidator)
            {
                ((RequiredFieldValidator)c).Enabled = enabled;
            }
            else
            {
                //break
            }

            if (c.HasControls())
            {
                SetControlsEnableState(c.Controls, enabled);
            }
        }
    }

    private Boolean isQueryStringValid()
    {
        //this iterates over querysting parameters
        //this will handle known querystring parameters and validate range, if any not valid range throw exception
        //if unknown parameter is found, throw exception

        Boolean _isValid = true;

        NameObjectCollectionBase.KeysCollection qryString = Request.QueryString.Keys ;
        
        foreach (string qryStringKey in qryString)
        {
            switch (qryStringKey)
            {
                case "id":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "statusId":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "searchText":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "saveStatus":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                    
                default:
                    
                    //do something here   
                    _isValid = false;   
                    break;
                    //throw new Exception("Unknown querystring parameter. " + qryStringKey);
            }

            if (!_isValid) 
            {
                break;
            }
        }

        return _isValid;
    }

    //private SessionFacade _SessionFacade = new SessionFacade();
    private string CreateStartUpMessage(bool isSaveSuccessMessage)
    {

        string Message = string.Empty;

        if (_OnStartupAlertErrorCollection == null && !SuppressSaveMessage)
        {
            if( isSaveSuccessMessage )
            {
                Message = "Save Successful.";
            }
            else
            {
                Message = "Save Failed.";
            }
        }
        else
        {
            if (_OnStartupAlertErrorCollection != null)
            {
                foreach (KeyValuePair<string, string> item in _OnStartupAlertErrorCollection)
                    Message += item.Value + "\\n";
            }

        }

        return Message;
    }
    /// <summary>
    /// Renders the massage in javascript alert. Modify if needed for section 508 compliance
    /// </summary>
    private void RenderStartUpMessage(bool IsSaveSuccessMessage)
    {
        StringBuilder sb = new StringBuilder();
        string Message = CreateStartUpMessage(IsSaveSuccessMessage);

        //HttpCookie cookie = this.Request.Cookies["test"];

        //if (cookie != null)
        //{
        //    cookie.Expires = DateTime.Now.AddDays(-1D);
        //    Response.Cookies.Add(cookie);  

        //}


        //if (Message != string.Empty && !Page.ClientScript.IsStartupScriptRegistered("alertMsg"))
        if (Message != string.Empty)
        {
            HiddenField HiddenFieldShowSaveMessage = this.Master.FindControl("HiddenFieldShowSaveMessage") as HiddenField;
            if (HiddenFieldShowSaveMessage != null)
                HiddenFieldShowSaveMessage.Value = "1";

            HiddenField HiddenFieldSaveMessage = this.Master.FindControl("HiddenFieldSaveMessage") as HiddenField;
            if (HiddenFieldSaveMessage != null)
                HiddenFieldSaveMessage.Value = Message;

            ///sb.Append("ShowSaveAlert();");

            //sb.Append("<script type = 'text/javascript' id ='test'>");
            //sb.Append("alert($('#" + field.ClientID + "').val());");
            //sb.Append("if (document.cookie.indexOf('test') == -1)");
            //sb.Append("{");
            //$('#<%= suppressSaveAlert.ClientID %>');
            //sb.Append("if ($('#" + field.ClientID  + "').val() == '0')"); 
            //sb.Append("     alert('" + Message + "');");
            //sb.Append("document.cookie = 'test';");
            //sb.Append("}");
            //sb.Append("$('#" + field.ClientID  + "').val('1');");
            //sb.Append("alert($('#" + field.ClientID + "').val());");     
            //sb.Append("</script>");
            //Page.ClientScript.RegisterStartupScript(this.GetType(), "alertMsg", "alert('" + Message + "');", true);

            //Page.ClientScript.RegisterStartupScript(this.GetType(), "alertMsg", sb.ToString(), false);   
        }
    }

    private bool DisplayApplicationWarning()
    {
        bool result = false;

        if (TopMenuName().ToLower() == "administration")
        {
            result = false;
        }
        else if (Session["SkipWarning"] != null)
        {
            if (Session["SkipWarning"].ToString() == "Yes")
            {
                result = false;
            }
        }
        else
        {
            RegistriesCommonManager commonManager = new RegistriesCommonManager();

            APPLICATION_STATUS appStatus = commonManager.GetApplicationStatus(WebConfigurationManager.AppSettings.Get("Registry"));

            if (appStatus != null)
            {
                if (appStatus.PROCESS_FLAG > 0)
                {
                    result = true;
                    Session["warningMessage"] = appStatus.MESSAGE;
                    Session["theUrl"] = Request.Url.Segments[Request.Url.Segments.Length - 1] + Request.Url.Query;

                    //Logging.WriteLogToFile("BasePage.DisplayApplicationWarning(): WarningRedirect: appStatus.PROCESS_FLAG > 0");
                    // This one happens as part of the normal login process, it shows the landing page.

                    Response.Redirect("TBIWarning.aspx?id=" + appStatus.PROCESS_FLAG);
                }
            }
        }

        return result;
    }

    #endregion Private Methods

    protected void manager_BOSaveSuccess(object sender, BaseBO.BOSaveSuccessEventArgs e)
    {
        if (!_errorOnSavedReceived)
        {
            BusinessObjectSaveEventReceived = true;
        }
        //IsSaveSuccess = (e.SaveStatusArg == BaseBO.SaveStatus.SaveSuccess);
    }
}